function Spath = Simulate_Diffusion_func_CEV2( N_sim, M, T, S_0,gamma, sigma,r,q)
% N_sim = # paths
% M = #time steps on [0,T], time step is dt=T/M, so each path has M+1 points
% T = time to maturity, ie path is on [0,T]
% S_0 = initial underlying value (e.g. S_0=100)
% r = interst rate (e.g. r = 0.05)
% q = dividend yield (e.g. q = 0.05)
% sigma = diffusion parameter (e.g. sigma = 0.2)
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dt = T/M;
Spath = zeros(N_sim,M+1);
Spath(:,1) = S_0;

for m = 1:M
    W1 = randn(N_sim,1); %shock
    Sigsqdt = sigma*sqrt(dt)*(Spath(:,m)).^(gamma);%variance, gamma or gamma+1
  % drift = kappa*(theta-Spath(:,m)).*dt;
   drift = (r-q).*dt;
    Spath(:,m+1) = max(Spath(:,m)+(drift + Sigsqdt.*W1).*Spath(:,m),10);  
end
